/*
 * Decompiled with CFR 0.152.
 */
package emt.gthandler.common.tileentities.machines.multi.generator;

import emt.gthandler.common.implementations.EssentiaHatch;
import emt.gthandler.common.items.EMT_CasingBlock;
import emt.util.EMTEssentiasOutputs;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.XSTR;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.common.config.ConfigBlocks;

public class EMT_Large_Essentia_Gen
extends GT_MetaTileEntity_MultiBlockBase {
    private static final byte CASING_INDEX = 2;
    public ArrayList<EssentiaHatch> mEssentiaHatches = new ArrayList();
    private byte tick = 0;
    private boolean has_lube = false;

    public EMT_Large_Essentia_Gen(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public EMT_Large_Essentia_Gen(String aName) {
        super(aName);
    }

    public String[] getDescription() {
        return new String[]{"Controller Block for the Large Essentia Generator.", "Produces energy from magical essentia decay.", "Size(WxHxD): 7x4x7, Controller (Bottom, Center)", "Top-Middle 5x1x5 layer are Muffler Hatches", "Middle 5x2x5 layer are Essentia Diffusion Cells", "Everything from here on goes either in the bottom or on the sides", "1x Fluid Input Hatch", "1x Essentia Input Hatch", "1x Dynamo Hatches", "1x Maintenance Hatch", "The outer hull is made out of Magic Containing Casings", "Produces 20x more than the singleblock generator per essentia", "Causes magical and serious conventional pollution", "Needs 1L Lubricant per second or will cause way more conventional pollution", "Needs 10 \u00a79Aqua\u00a77 cVis per second or will cause way more magical pollution", "Added by EMT", "Made by bartimaeusnek"};
    }

    public int getCurrentEfficiency(ItemStack itemStack) {
        return this.mEfficiency - (this.getIdealStatus() - this.getRepairStatus()) * this.getMaxEfficiency(itemStack) / 10;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[2], new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER))};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[2]};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new EMT_Large_Essentia_Gen(this.mName);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public String func_145825_b() {
        return this.mName;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack arg1) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * 3;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * 3;
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int h = 0; h <= 3; ++h) {
                    IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, h, zDir + z);
                    if (Math.abs(x) != 3 && Math.abs(z) != 3) {
                        if (h == 3) {
                            if (this.addMufflerToMachineList(tTileEntity, 2)) continue;
                            return false;
                        }
                        if (h != 0) {
                            if (aBaseMetaTileEntity.getBlockOffset(xDir + x, h, zDir + z) != EMT_CasingBlock.EMT_GT_BLOCKS[0]) {
                                return false;
                            }
                            if (aBaseMetaTileEntity.getMetaIDOffset(xDir + x, h, zDir + z) == 1) continue;
                            return false;
                        }
                        if (this.addEssetiaHatchToList(tTileEntity, 2) || this.addDynamoToMachineList(tTileEntity, 2) || this.addMaintenanceToMachineList(tTileEntity, 2) || this.addInputToMachineList(tTileEntity, 2)) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + x, h, zDir + z) != EMT_CasingBlock.EMT_GT_BLOCKS[0]) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + x, h, zDir + z) == 0) continue;
                        return false;
                    }
                    if (h != 0) {
                        if (this.addEssetiaHatchToList(tTileEntity, 2) || this.addDynamoToMachineList(tTileEntity, 2) || this.addMaintenanceToMachineList(tTileEntity, 2) || this.addInputToMachineList(tTileEntity, 2)) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + x, h, zDir + z) != EMT_CasingBlock.EMT_GT_BLOCKS[0]) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + x, h, zDir + z) == 0) continue;
                        return false;
                    }
                    if (h != 0 || this.addEssetiaHatchToList(tTileEntity, 2) || this.addDynamoToMachineList(tTileEntity, 2) || this.addMaintenanceToMachineList(tTileEntity, 2) || this.addInputToMachineList(tTileEntity, 2) || xDir + x == 0 && zDir + z == 0) continue;
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + x, h, zDir + z) != EMT_CasingBlock.EMT_GT_BLOCKS[0]) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + x, h, zDir + z) == 0) continue;
                    return false;
                }
            }
        }
        if (this.mDynamoHatches.size() != 1) {
            return false;
        }
        if (this.mInputHatches.size() != 1) {
            return false;
        }
        return this.mMaintenanceHatches.size() == 1;
    }

    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity instanceof EssentiaHatch) {
            return this.addEssetiaHatchToList(aTileEntity, aBaseCasingIndex);
        }
        return super.addInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    private boolean addEssetiaHatchToList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof EssentiaHatch) {
            ((EssentiaHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mEssentiaHatches.add((EssentiaHatch)aMetaTileEntity);
        }
        return false;
    }

    private void make_energy() {
        AspectList fuel = this.mEssentiaHatches.get(0).getAspects();
        double cached = 0.0;
        this.tick = (byte)(this.tick + 1);
        for (Aspect A : fuel.aspects.keySet()) {
            if (fuel.getAmount(A) <= 0) continue;
            double burnvalue = EMTEssentiasOutputs.outputs.get(A.getTag());
            cached += burnvalue / 20.0;
            cached = Math.ceil(cached);
            if (this.tick % 20 != 0) continue;
            this.mEssentiaHatches.get(0).getAspects().reduce(A, 1);
            if (this.mEssentiaHatches.get(0).getAspects().getAmount(A) != 0) continue;
            this.mEssentiaHatches.get(0).getAspects().remove(A);
        }
        if (this.tick % 20 == 0) {
            if (this.has_lube) {
                --((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).getFluid().amount;
            }
            this.tick = 0;
        }
        this.mEUt = (int)Math.ceil(cached);
    }

    public boolean checkRecipe(ItemStack arg0) {
        if (this.mEssentiaHatches.get(0).fuelleft() > 0) {
            this.mMaxProgresstime = 1;
            this.mProgresstime = 0;
        }
        return this.mEssentiaHatches.get(0).fuelleft() > 0;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.tick % 20 == 0) {
            this.mEfficiency = this.mEfficiency < this.getMaxEfficiency(null) - 320 ? (this.mEfficiency += 320) : this.getMaxEfficiency(null);
            boolean bl = this.has_lube = ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get(0)).getFluid() != null && ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get(0)).getFluid().isFluidEqual(Materials.Lubricant.getFluid(1L)) && ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get(0)).getFluidAmount() > 0;
        }
        if (this.tick % 2 == 0) {
            int z;
            int y;
            int x;
            XSTR R = new XSTR();
            World WORLD = this.getBaseMetaTileEntity().getWorld();
            boolean outOfcVis = VisNetHandler.drainVis((World)WORLD, (int)(x = this.getBaseMetaTileEntity().getXCoord()), (int)(y = this.getBaseMetaTileEntity().getYCoord()), (int)(z = this.getBaseMetaTileEntity().getZCoord()), (Aspect)Aspect.WATER, (int)10) <= 9;
            int RANDOMHATCH = R.nextInt(this.mMufflerHatches.size());
            if (R.nextInt(this.getMaxEfficiency(null)) > (this.mEfficiency > 100 ? this.mEfficiency : 100) || outOfcVis) {
                x = ((GT_MetaTileEntity_Hatch_Muffler)this.mMufflerHatches.get(RANDOMHATCH)).getBaseMetaTileEntity().getXCoord();
                y = ((GT_MetaTileEntity_Hatch_Muffler)this.mMufflerHatches.get(RANDOMHATCH)).getBaseMetaTileEntity().getYCoord() + 1;
                z = ((GT_MetaTileEntity_Hatch_Muffler)this.mMufflerHatches.get(RANDOMHATCH)).getBaseMetaTileEntity().getZCoord();
                WORLD.func_147465_d(x, y, z, ConfigBlocks.blockFluxGas, R.nextInt(8), 3);
            }
        }
        this.make_energy();
        ++this.mProgresstime;
        return super.onRunningTick(aStack);
    }

    public boolean explodesOnComponentBreak(ItemStack arg0) {
        return false;
    }

    public int getDamageToComponent(ItemStack arg0) {
        return 0;
    }

    public int getMaxEfficiency(ItemStack arg0) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack arg0) {
        return this.has_lube ? 50 : 1000;
    }

    public boolean isCorrectMachinePart(ItemStack arg0) {
        return true;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        String[] old = super.getInfoData();
        old[2] = "Produces \u00a74" + this.mEUt + "\u00a7f" + "EU/t";
        return old;
    }
}

